%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% --------------------Soporte--------------------------
% Este es el formato para la Revista de la Escuela de Física
% Ediciones anteriores Jorge Sauceda y Marlon Interiano
% Edición Julio, 2016 - José Núñez
% Edición Enero 2018 - Amalia Escobar
% Soporte: revista.ref@unah.edu.hn 
% -----------------------------------------------------
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
\NeedsTeXFormat{LaTeX2e}
\ProvidesClass{REF}[2018/01/15, v1]

%-------Primeras Definiciones--------
\def\@titulo{}
\def\@email{}
\def\@AutorPrincipal{}
\def\@recibido{}
\def\@aceptado{}
\def\@Agradecimiento{}
\def\@Thanks

\def\@REF{}
\def\@detalles{}
\def\@doi{}
\def\@papereditor{}

\newif\if@apa
\newif\if@numrefs
\newif\if@alpharefs
\newif\if@amsrefs
\newif\if@blindreview

%---------Opciones de Bibliografia------------
\DeclareOption{apa}{
  \@numrefsfalse
  \@alpharefstrue
  \@amsrefsfalse
}  
\DeclareOption{alpharefs}{  
  \@numrefstrue
  \@alpharefsfalse
  \@amsrefsfalse
}
\DeclareOption{ams-refs}{
  \@numrefsfalse
  \@alpharefsfalse
  \@amsrefstrue
}

\ExecuteOptions{alpharefs}
\ProcessOptions\relax

%----------------------------------------------


\LoadClass[twoside]{article}

\RequirePackage[spanish,es-tabla]{babel}
\RequirePackage[table]{xcolor}
\RequirePackage{ifpdf}
\RequirePackage{booktabs} 	
\RequirePackage{cuted}
\RequirePackage{ifxetex}
\RequirePackage{ifluatex}
\RequirePackage[T1]{fontenc}
\RequirePackage[utf8]{inputenc}
\RequirePackage{float}
\RequirePackage{listings}	
\RequirePackage{bm}
\RequirePackage{lettrine}
\RequirePackage{multirow}
\RequirePackage{multicol}
\RequirePackage{graphicx}
\RequirePackage{titling}
\RequirePackage{longtable}
\RequirePackage{tabularx}
\RequirePackage{textcase}
\RequirePackage{dashrule}
\RequirePackage[lastpage,user]{zref}
\RequirePackage{ragged2e}
\RequirePackage{authblk}
\RequirePackage[hyphens]{url}
\RequirePackage{soul}
\RequirePackage{subcaption}
\RequirePackage{ccicons}
\RequirePackage{xpatch}
\RequirePackage[font={small,it}]{caption}

\newif\ifxetexorluatex
\ifxetex
  \xetexorluatextrue
\else
  \ifluatex
    \xetexorluatextrue
  \else
    \xetexorluatexfalse
 \fi
\fi

\RequirePackage[framemethod=tikz]{mdframed}
\RequirePackage{silence}
\WarningFilter{microtype}{tracking amount list}
\WarningFilter{latex}{Reference `mdf@pagelabel}

\RequirePackage{microtype}
\RequirePackage
 [paperwidth=171mm,paperheight=246mm,
  left=14.3mm,textwidth=142.4mm, textheight=20cm, headsep=2\baselineskip,includehead,includefoot,heightrounded, bottom=1.5cm,top=1cm]{geometry}

\RequirePackage{alphalph}
\newalphalph{\fnsymbolmult}[mult]{\@fnsymbol}{5}

\newcounter{authorfn}
\setcounter{authorfn}{1}
\newcommand{\authfn}[1]{%
  \fnsymbolmult{#1}%
}
%------Paqueteria y librerias Tikz----------
\RequirePackage{tikz}
\RequirePackage{tikzpagenodes} 
\usetikzlibrary{shadows} 
\usetikzlibrary{positioning}
\usetikzlibrary{mindmap}
\usetikzlibrary{decorations.pathmorphing, patterns}
\usetikzlibrary{snakes}
\usetikzlibrary{trees}
\usetikzlibrary{calc}
\usetikzlibrary{shapes.callouts}
\usetikzlibrary{shapes,arrows}

%-------Paqueteria Matematica--------------
\RequirePackage{amssymb} 
\RequirePackage{mathtools}
\RequirePackage{amsmath} 
\RequirePackage{amsthm}
\RequirePackage{latexsym}
\RequirePackage{amsfonts}
\RequirePackage{xparse}
\RequirePackage{physics}
\everymath{\displaystyle}
\decimalpoint

\newtheorem{theorem}{Theorem}
\newtheorem{lemma}[theorem]{Lemma}
\newtheorem{proposition}[theorem]{Proposition}
\newtheorem{corollary}[theorem]{Corollary}

\newenvironment{definition}[1][Definition]{\begin{trivlist}
\item[\hskip \labelsep {\bfseries #1}]}{\end{trivlist}}
\newenvironment{example}[1][Example]{\begin{trivlist}
\item[\hskip \labelsep {\bfseries #1}]}{\end{trivlist}}
\newenvironment{remark}[1][Remark]{\begin{trivlist}
\item[\hskip \labelsep {\bfseries #1}]}{\end{trivlist}}

%-------Segundas Definiciones-------
\newcommand{\titulo}[1]{\def\@titulo{#1}}
\newcommand{\AutorPrincipal}[1]{\def\@AutorPrincipal{#1}}
\newcommand{\recibido}[1]{\def\@recibido{#1}}
\newcommand{\aceptado}[1]{\def\@aceptado{#1}}
\newcommand{\Agradecimiento}[1]{\def\@Agradecimiento{#1}}
\newcommand{\Thanks}[1]{\def\@Thanks{#1}}

\newcommand{\doi}[1]{\def\@doi{\url{#1}}}
\newcommand{\papereditor}[1]{\def\@papereditor{#1}}
\newcommand{\REF}[1]{\def\@REF{#1}}
\newcommand{\detalles}[1]{\def\@detalles{#1}}
\newcommand{\email}[1]{\def\@email{#1}}

%-------------Formato del "Seccionado"------------------
\renewcommand{\thesection}{\Roman{section}}
\renewcommand{\thesubsection}{\arabic{subsection}} 
\newcommand{\allcaps}[2][]{\textls*[#1]{\MakeTextUppercase{#2}}}

\RequirePackage[explicit]{titlesec}

\titleformat{\section}
  {\fontsize{10pt}{12\p@}\bfseries}
  {\thesection}{1em}{\textmd{|}\quad\allcaps{#1}}

\titlespacing*{\section}{0pt}{1\baselineskip}{\baselineskip}
\titlespacing*{name=\section,numberless}{0pt}{1\baselineskip}{0.5\baselineskip}

\titleformat{\subsection}
  {\fontsize{10pt}{13\p@}\bfseries}
  {\thesubsection}{0.2em}{|\hskip4pt #1}

\titlespacing*{\subsection}{1pt}{1.5\baselineskip}{0.5\baselineskip}

\titleformat{\subsubsection}
  {\fontsize{10pt}{13\p@}\bfseries}
  {\thesubsubsection}{1em}{\textmd{|}\quad#1}
\titlespacing*{\subsubsection}{0pt}{1.5\baselineskip}{0.5\baselineskip}

\titleformat{\paragraph}[hang]
  {\fontsize{8.5\p@}{13\p@}\fontseries{eb}\selectfon\color{black!75}}
  {\theparagraph}{0pt}{#1}
\titleformat{name=\paragraph,numberless}[hang]
  {\fontsize{8.5\p@}{13\p@}\fontseries{eb}\selectfont}
  {}{0pt}{#1}

\titlespacing*{\paragraph}{0pt}{\baselineskip}{0pt}

\titleformat{\subparagraph}[runin]
 {\normalsize\fontseries{eb}\selectfont\color{black!75}}
 {\thesubparagraph}{0pt}{#1}

%------------footer primera pagina--------------------------
\RequirePackage[flushmargin,bottom]{footmisc}
\def\blfootnote{\gdef\@thefnmark{}\@footnotetext}
\appto{\footnotelayout}{\fontsize{6\p@}{9\p@}\selectfont}
\renewcommand{\footnoterule}{\noindent\textcolor{black!50}{\rule{\textwidth}{0.5\p@}}\vskip2\p@}

%---------Configuración del Autor y Afiliaciones -------------
\setcounter{Maxaffil}{1}
\renewcommand{\Authsep}{,\ \ \ }
\renewcommand{\Authand}{,\ \ \ }
\renewcommand{\Authands}{,\ \ \ }
\renewcommand{\Authfont}{\fontsize{11\p@}{12pt}\scshape\raggedright}
\renewcommand{\Affilfont}{\fontsize{7\p@}{12pt}\em\raggedright}
\renewcommand\AB@authnote[1]{\textsuperscript{#1}}

\patchcmd{\AB@affilsepx}{\\}{\\[6\p@]}{}{}
\patchcmd{\@author}{\AB@authlist\\[\affilsep]\AB@affillist}{\AB@authlist}{}{}

%-------------Opciones de Pagina Principal--------------------
\renewcommand{\maketitle}{
\begingroup
  \setul{3\p@}{1\p@}\vspace*{-1.5cm}

\noindent  \includegraphics[scale=0.18]{logo.eps}

  \\[2\p@]
  {\fontsize{8\p@}{15\p@}
    \textls*[150]{\color{black} \@detalles }   \  {\color{black} DOI: \@doi }
  }
  \endgroup
  \vskip15\p@
  {\fontsize{14\p@}{20\p@}\bfseries\raggedright\@titulo\par}
  \vskip3\p@
  {\fontsize{12\p@}{20\p@}\bfseries\raggedright\@title\par}
  \vskip15\p@
  {\noindent\begin{minipage}{\textwidth}{\fontsize{10\p@}{15\p@}\@author}\end{minipage}}
  \vskip24\p@
  {\begin{minipage}{\textwidth}{\itshape\fontsize{9\p@}{10\p@} {\bf Recibido:} \@recibido \hspace*{2pt}/\hspace*{2pt} {\bf Aceptado:} \@aceptado}\end{minipage}}
  \vskip28\p@%
  \thispagestyle{firstpage}
}

%------------------Lateral------------------------
\newcommand{\REF@affilmetadata}{
  \vskip2pt
  \AB@affillist\par
  \vskip18pt

  \ifx\empty\@Agradecimiento
  \else
    \@Agradecimiento\par
    \vskip2pt
    \textbf{Special Thanks}\\  
    \@Thanks\par
  \fi
  \vskip2pt}

%------------Abstract & Extra---------------
\definecolor{peach}{rgb}{1.0, 0.9, 0.71}

\RequirePackage{changepage}
\RequirePackage{environ}
\reversemarginpar
\newlength{\REF@affilmetadataheight}
\newlength{\REF@abstractheight}
\NewEnviron{REF@abstract}{%
  \newcommand{\palabrasclaves}[1]{%
    \vskip8\p@%
    \noindent{\bfseries\fontsize{7\p@}{13\p@}\allcaps{palabras claves}\par}
    \noindent{\raggedright\fontsize{8\p@}{13\p@}\selectfont ##1\par}
  }%
    \newcommand{\keywords}[1]{%
    \vskip8\p@%
    \noindent{\bfseries\fontsize{7\p@}{13\p@}\allcaps{keywords}\par}
    \noindent{\raggedright\fontsize{8\p@}{13\p@}\selectfont ##1\par}
  }%
  \newcommand{\pacs}[1]{%
    \vskip8\p@%
    \noindent{\bfseries\fontsize{7\p@}{13\p@}\allcaps{pacs}\par}
    \noindent{\raggedright\fontsize{8\p@}{13\p@}\selectfont ##1\par}
  }%
  \strictpagecheck%
  \begin{adjustwidth*}{\dimexpr 54.9mm-6.5\p@}{}%
  \setlength{\marginparsep}{-47mm}%
  \setlength{\marginparwidth}{47mm}%
  \settototalheight{\REF@affilmetadataheight}{\parbox{\marginparwidth}{\REF@affilmetadata}}%
  \newsavebox{\REF@abstractbox}%
  
  \savebox{\REF@abstractbox}{%
    \parbox{\linewidth}{%
    \begin{mdframed}[font=\fontsize{8\p@}{15\p@}\selectfont,
      topline=false,bottomline=false,
      leftline=true,rightline=false,
      backgroundcolor=peach,
      middlelinewidth=6\p@,middlelinecolor=white,
      outerlinewidth=0.5\p@]
      \setlength{\baselineskip}{2pt}
      \BODY
    \end{mdframed}}
  }
  \settototalheight{\REF@abstractheight}{\usebox{\REF@abstractbox}}
  \marginpar{\REF@affilmetadata}\vskip-1.5em
  \begin{mdframed}[font=\fontsize{8\p@}{15\p@}\selectfont,
  topline=false,bottomline=false,
  leftline=true,rightline=false,
  backgroundcolor=peach,
  middlelinewidth=6\p@,middlelinecolor=white,
  outerlinewidth=0.5\p@]
  \setlength{\baselineskip}{2pt}
  \BODY
  \end{mdframed}
  \ifdimgreater
    {\REF@affilmetadataheight}
    {\REF@abstractheight}
    {\vskip\dimexpr\REF@affilmetadataheight-\REF@abstractheight+0.5\baselineskip\relax}{}
}[\end{adjustwidth*}]

\renewcommand{\abstract}{\REF@abstract}
\renewcommand{\endabstract}{\endREF@abstract}

%------Configuración Enumerate/Itemize------
\RequirePackage[inline]{enumitem}
%\setlist{nosep,font=\scshape,leftmargin=*,align=left,before=\raggedcolumns\begin{multicols}{2},after=\end{multicols}}
\setlist[1]{topsep=\baselineskip,leftmargin=0.3cm,labelsep=*,labelwidth=*}
\setlist[enumerate,2]{label={\arabic*.}}

%---------Espacio para Ecuaciones-----------


%---------Configuración de Captions------------
\RequirePackage[tableposition=top]{caption}
\DeclareCaptionFont{captionfont}{\fontsize{8\p@}{11\p@}\selectfont}
\DeclareCaptionFont{boxcaption}{\fontsize{9\p@}{13\p@}\selectfont}
  \ifpdf
  \DeclareCaptionLabelFormat{allcaps}{\textls[150]{\MakeTextUppercase{#1}~#2}}
\captionsetup*[table]{skip=1ex}

%---------Configuración Tablas-------------------
\AtBeginEnvironment{table}{%
  \fontsize{7\p@}{10.5\p@}\selectfont%
  \renewcommand{\arraystretch}{1.25}%
  \arrayrulecolor{black!70}%
  \setlength{\arrayrulewidth}{1\p@}%
}


\RequirePackage{threeparttable}
\renewcommand{\TPTnoteSettings}{\leftmargin=0pt}
\newcommand{\headrow}{\rowcolor{black!20}}
\newcommand{\thead}[1]{\multicolumn{1}{l}{\bfseries #1\rule[-1.2ex]{0pt}{2em}}}

%% Boxes!
\RequirePackage{newfloat}
\DeclareFloatingEnvironment[placement=bt,name=box]{featurebox}
\captionsetup*[featurebox]{skip=1em,labelformat={default},font={large,boxcaption},labelfont={sc,color=black!75}}
\AtBeginEnvironment{featurebox}{%
  \setlist*{topsep=0pt}%
}
\apptocmd{\featurebox}{%
  \begin{mdframed}[linewidth=5\p@,linecolor=black!20,
  innerleftmargin=12\p@,innerrightmargin=12\p@,
  innertopmargin=12\p@,innerbottommargin=12\p@]
}{}{}
\pretocmd{\endfeaturebox}{\end{mdframed}}{}{}


% Skips for floats
\setlength{\floatsep}{1.5\baselineskip}
\setlength{\intextsep}{\baselineskip}
\setlength{\textfloatsep}{1.5\baselineskip}

% The endnotes
\RequirePackage{enotez}
\newlist{enotezlist}{itemize}{1}
\setlist[enotezlist,1]{leftmargin=*,label=\arabic*,labelsep=0.25em,itemsep=0pt,topsep=0.5\baselineskip}
\EditInstance{enotez-list}{itemize}
{list-type=enotezlist}
\setenotez{list-name={endnotes},list-style=itemize}
\EditInstance{enotez-list}{itemize}{
  format=\fontsize{7.5\p@}{10.5\p@}\selectfont,
  number = \textsuperscript{#1}
}


% References
\if@apa
  \RequirePackage[natbibapa]{apacite}
  \bibliographystyle{apacite}
\fi
\if@alpharefs
    \RequirePackage[natbibapa]{apacite}
    \bibliographystyle{apacite}
\fi
\if@amsrefs
  \RequirePackage{amsrefs}
  \let\citep\cite
  \let\citet\ocite
  \renewcommand{\biblistfont}{\fontsize{7.5\p@}{10.5\p@}\selectfont}
\fi

\AtBeginDocument{
  \@ifpackageloaded{apacite}{
    \setlength{\bibhang}{2em}
    \renewcommand{\bibfont}{\fontsize{9\p@}{10.5\p@}\selectfont}
    \renewcommand{\refname}{Referencias}
    \renewcommand{\bibname}{Referencias}
  }{}
}

%---------------Sección para editores---------------------------
\RequirePackage{fancyhdr}
\fancyhf{}
\renewcommand{\headrule}{}
\fancyhead[L]{{\fontsize{7\p@}{13\p@}\selectfont%
  \setlength{\arrayrulewidth}{.5\p@}%
  \arrayrulecolor{black}%
  \begin{tabularx}{\textwidth}{@{}X | r @{}}%
  \textsc{\thepage} & REF-UNAH v8i2, 80-\zpageref{LastPage} (2020) \hspace{12cm} \\\hline
\end{tabularx}
}}

\fancyfoot[C]{\thepage}

%------ Página Principal-------------------------------
\fancypagestyle{firstpage}{
\fancyhead[L]{}
\fancyfoot[C]{}  

\fancyfoot[R]{\fontsize{8\p@}{10pt}\selectfont  \setlength{\arrayrulewidth}{.5\p@}
 \arrayrulecolor{black}\raggedright
   * Esta obra está bajo una licencia Creative Commons Reconocimiento - NoComercial  4.0 Internacional \ccbync \\ * This work is licensed under a Creative Commons Attribution-NonCommercial 4.0 International License. \ccbync
   \\[3\p@]
   \begingroup
  \fontsize{7\p@}{13\p@}\selectfont%
  \begin{tabularx}{\textwidth}{@{}X  >{\centering\arraybackslash}X  r | r @{}}%
  \hline
  \thepage
  \end{tabularx}%
   \endgroup
  }
}

%-------General--------------------------
\RequirePackage{pslatex}
\RequirePackage{hyperref}
\normalsize
\setlength{\parindent}{0pt}
\pagestyle{fancy}
\setcounter{page}{1}
